/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.IAmmoProvider;
import dev.toma.gunsrpg.common.container.TurretContainer;
import dev.toma.gunsrpg.common.entity.SynchronizableEntity;
import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.entity.projectile.Bullet;
import dev.toma.gunsrpg.common.entity.projectile.IReaction;
import dev.toma.gunsrpg.common.entity.projectile.Rocket;
import dev.toma.gunsrpg.common.init.ModContainers;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.common.item.guns.ammo.IReactiveMaterial;
import dev.toma.gunsrpg.common.item.guns.util.IEntityTrackingGun;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.S2C_SendEntityData;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.locate.ILocatorPredicate;
import dev.toma.gunsrpg.util.locate.ammo.ItemLocator;
import dev.toma.gunsrpg.util.properties.Properties;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public final class TurretEntity
extends Entity
implements SynchronizableEntity {
    public static final int INVENTORY_SIZE = 8;
    public static final ITextComponent SCREEN_TITLE = new TranslationTextComponent("screen.gunsrpg.turret");
    private static final Vector3d GRAVITY_VEC = new Vector3d(0.0, -0.3, 0.0);
    private final TurretType turretType;
    private final Inventory inventory = new Inventory(8);
    private UUID owner;
    private final Set<UUID> whitelist = new HashSet<UUID>();
    private final Map<UUID, String> nameCache = new HashMap<UUID, String>();
    private TargettingMode targettingMode;
    private int targetSearchDelay;
    private int attackDelay;
    private LivingEntity target;

    public TurretEntity(EntityType<? extends TurretEntity> type, TurretType turretType, World world) {
        super(type, world);
        this.turretType = turretType;
        this.targettingMode = TargettingMode.NONE;
    }

    public static TurretEntity smg(EntityType<? extends TurretEntity> type, World world) {
        return new TurretEntity(type, Turrets.SMG, world);
    }

    public static TurretEntity ar(EntityType<? extends TurretEntity> type, World world) {
        return new TurretEntity(type, Turrets.AR, world);
    }

    public static TurretEntity rocket(EntityType<? extends TurretEntity> type, World world) {
        return new TurretEntity(type, Turrets.ROCKET, world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.targettingMode.isDisabled()) {
            if (this.target == null) {
                if (--this.targetSearchDelay <= 0) {
                    this.refreshTarget();
                }
            } else if (this.validateTargetExistsOrRefresh()) {
                this.rotateTowardsTarget(this.turretType.rotationSpeed);
                if (--this.attackDelay <= 0 && this.isFacingTarget()) {
                    this.attackDelay = this.turretType.attackDelay;
                    ItemStack ammo = this.findAmmo();
                    if (!ammo.func_190926_b()) {
                        IAmmoProvider provider = (IAmmoProvider)ammo.func_77973_b();
                        if (!this.field_70170_p.field_72995_K) {
                            AbstractProjectile projectile = this.turretType.shootHandler.createProjectile(this, ammo, provider);
                            if (GunsRPG.config.skills.countTrapKills) {
                                projectile.func_212361_a(this.getOwnerEntity());
                            }
                            this.field_70170_p.func_217376_c((Entity)projectile);
                            ammo.func_190918_g(1);
                            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.turretType.shootSound, SoundCategory.NEUTRAL, this.turretType.shootSoundVolume, 1.0f);
                        }
                        if (this.turretType.adjustTargetAfterShooting) {
                            this.refreshTarget();
                        }
                    }
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_180799_ab()) {
            this.func_70106_y();
        }
        this.func_213317_d(GRAVITY_VEC);
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public boolean func_70067_L() {
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.turretType.dropStack.func_77946_l();
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.isAuthorized(player) && !this.field_70170_p.field_72995_K) {
            int entityId = this.func_145782_y();
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((containerId, playerInventory, user) -> new TurretContainer((ContainerType<? extends TurretContainer>)((ContainerType)ModContainers.TURRET_CONTAINER.get()), containerId, playerInventory, entityId, (IInventory)this.inventory), SCREEN_TITLE), buffer -> buffer.writeInt(entityId));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        PlayerEntity player;
        Entity entity = source.func_76364_f();
        if (entity == null || source.func_94541_c()) {
            return false;
        }
        if (entity instanceof PlayerEntity && !this.field_70170_p.field_72995_K && this.isAuthorized(player = (PlayerEntity)entity)) {
            ItemStack stack = this.turretType.dropStack.func_77946_l();
            ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
            this.field_70170_p.func_217376_c((Entity)itemEntity);
            InventoryHelper.func_180175_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (IInventory)this.inventory);
            this.func_70106_y();
            return true;
        }
        return false;
    }

    public boolean func_241845_aY() {
        return true;
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74768_a("targetDelay", this.targetSearchDelay);
        nbt.func_74768_a("attackDelay", this.attackDelay);
        this.saveSharedNbtData(nbt);
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.targetSearchDelay = nbt.func_74762_e("targetDelay");
        this.attackDelay = nbt.func_74762_e("attackDelay");
        this.loadSharedNbtData(nbt);
    }

    @Override
    public CompoundNBT serializeNetworkData() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.target != null) {
            nbt.func_74768_a("target", this.target.func_145782_y());
        }
        this.saveSharedNbtData(nbt);
        return nbt;
    }

    @Override
    public void deserializeNetworkData(CompoundNBT tag) {
        Entity entity;
        if (tag.func_74764_b("target") && (entity = this.field_70170_p.func_73045_a(tag.func_74762_e("target"))) instanceof LivingEntity) {
            this.target = (LivingEntity)entity;
        }
        this.loadSharedNbtData(tag);
    }

    private void saveSharedNbtData(CompoundNBT tag) {
        tag.func_74768_a("targetMode", this.targettingMode.ordinal());
        ListNBT inventoryTag = new ListNBT();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            CompoundNBT slotTag = new CompoundNBT();
            slotTag.func_74768_a("slot", i);
            slotTag.func_218657_a("item", (INBT)stack.serializeNBT());
            inventoryTag.add((Object)slotTag);
        }
        tag.func_218657_a("inventory", (INBT)inventoryTag);
        ListNBT names = new ListNBT();
        for (Map.Entry<UUID, String> entry : this.nameCache.entrySet()) {
            CompoundNBT entryTag = new CompoundNBT();
            entryTag.func_186854_a("uuid", entry.getKey());
            entryTag.func_74778_a("name", entry.getValue());
            names.add((Object)entryTag);
        }
        tag.func_218657_a("whitelist", (INBT)names);
    }

    private void loadSharedNbtData(CompoundNBT tag) {
        this.targettingMode = ModUtils.getEnumByIdSafely(tag.func_74762_e("targetMode"), TargettingMode.class);
        this.inventory.func_174888_l();
        this.whitelist.clear();
        this.nameCache.clear();
        ListNBT inventoryTag = tag.func_150295_c("inventory", 10);
        for (int i = 0; i < inventoryTag.size(); ++i) {
            CompoundNBT slotTag = inventoryTag.func_150305_b(i);
            int slot = slotTag.func_74762_e("slot");
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)slotTag.func_74775_l("item"));
            this.inventory.func_70299_a(slot, stack);
        }
        ListNBT whitelist = tag.func_150295_c("whitelist", 10);
        for (int i = 0; i < whitelist.size(); ++i) {
            CompoundNBT whitelistEntry = whitelist.func_150305_b(i);
            UUID uuid = whitelistEntry.func_186857_a("uuid");
            String name = whitelistEntry.func_74779_i("name");
            this.nameCache.put(uuid, name);
            this.whitelist.add(uuid);
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    public boolean isAuthorized(PlayerEntity player) {
        return this.owner == null || player.func_110124_au().equals(this.owner);
    }

    public void setOwner(UUID owner) {
        if (owner != null) {
            this.owner = owner;
            this.addToWhitelist(owner);
        }
    }

    @Nullable
    public Entity getOwnerEntity() {
        if (this.owner == null) {
            return null;
        }
        return this.field_70170_p.func_217371_b(this.owner);
    }

    public void addToWhitelist(UUID uuid) {
        PlayerEntity player = this.field_70170_p.func_217371_b(uuid);
        if (player != null) {
            this.whitelist.add(uuid);
            this.nameCache.put(uuid, player.func_145748_c_().getString());
            this.synchronizeToClients();
        }
    }

    public void removeFromWhitelist(UUID uuid) {
        this.whitelist.remove(uuid);
        this.nameCache.remove(uuid);
        this.synchronizeToClients();
    }

    public Map<UUID, String> getNameCache() {
        return this.nameCache;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Predicate<ItemStack> getAmmoFilter() {
        return this.turretType.ammoFilter;
    }

    public TargettingMode getTargettingMode() {
        return this.targettingMode;
    }

    public void setTargettingMode(TargettingMode targettingMode) {
        if (this.isValidTargettingMode(targettingMode)) {
            this.targettingMode = targettingMode;
            this.synchronizeToClients();
        }
    }

    public boolean isValidTargettingMode(TargettingMode targettingMode) {
        return this.turretType.availableTargettingModes.contains((Object)targettingMode);
    }

    public Set<TargettingMode> getAvailableTargettingModes() {
        return this.turretType.availableTargettingModes;
    }

    private ItemStack findAmmo() {
        return ItemLocator.findFirst((IInventory)this.inventory, this.turretType.ammoFilter);
    }

    private void refreshTarget() {
        this.targetSearchDelay = 20;
        this.attackDelay = Math.max(this.turretType.attackDelay, 20);
        AxisAlignedBB aabb = this.func_174813_aQ().func_72314_b(this.turretType.xzSearchRange, this.turretType.ySearchRange, this.turretType.xzSearchRange);
        List availableEntities = this.field_70170_p.func_175647_a(LivingEntity.class, aabb, entity -> entity.func_70685_l((Entity)this) && this.targettingMode.isValidTarget(this, (LivingEntity)entity));
        this.target = availableEntities.isEmpty() ? null : this.turretType.targetSelector.getTarget(availableEntities, this);
        this.synchronizeToClients();
    }

    private boolean validateTargetExistsOrRefresh() {
        if (!(this.target != null && this.target.func_70089_S() && this.field_70170_p.func_73045_a(this.target.func_145782_y()) != null && this.target.func_70685_l((Entity)this) && this.turretType.targetValidator.canConsiderAsTarget(this, this.target))) {
            this.refreshTarget();
        }
        return this.target != null;
    }

    private void synchronizeToClients() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        NetworkManager.sendToAllTracking(this, S2C_SendEntityData.forEntity(this));
    }

    private boolean isFacingTarget() {
        if (this.target == null) {
            return false;
        }
        Vector3d viewVec = this.func_70676_i(1.0f).func_72432_b();
        Vector3d posDiffVec = new Vector3d(this.target.func_226277_ct_() - this.func_226277_ct_(), this.target.func_226278_cu_() - this.func_226280_cw_(), this.target.func_226281_cx_() - this.func_226281_cx_());
        double length = posDiffVec.func_72433_c();
        double dot = viewVec.func_72430_b(posDiffVec = posDiffVec.func_72432_b());
        return dot > 1.0 - 0.25 / length && this.target.func_70685_l((Entity)this);
    }

    private void rotateTowardsTarget(float rotationSpeed) {
        Vector3d pos = this.func_213303_ch();
        Vector3d targetPos = this.target.func_213303_ch();
        float xDiff = TurretEntity.getXRotationDifference(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c);
        float yDiff = TurretEntity.getYRotationDifference(pos.field_72450_a, pos.field_72449_c, targetPos.field_72450_a, targetPos.field_72449_c);
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.field_70125_A = TurretEntity.rotateTowards(this.field_70125_A, xDiff, rotationSpeed);
        this.field_70177_z = TurretEntity.rotateTowards(this.field_70177_z, yDiff, rotationSpeed);
    }

    private static float rotateTowards(float rotation, float rotationDifference, float rotationSpeed) {
        float f = MathHelper.func_203302_c((float)rotation, (float)rotationDifference);
        float f1 = MathHelper.func_76131_a((float)f, (float)(-rotationSpeed), (float)rotationSpeed);
        return rotation + f1;
    }

    private static float getXRotationDifference(double x1, double y1, double z1, double targetX, double targetY, double targetZ) {
        double x = targetX - x1;
        double y = targetY - y1;
        double z = targetZ - z1;
        double xzDist = Math.sqrt(x * x + z * z);
        return (float)(-(MathHelper.func_181159_b((double)y, (double)xzDist) * 57.29577951308232));
    }

    private static float getYRotationDifference(double x1, double z1, double targetX, double targetZ) {
        double x = targetX - x1;
        double z = targetZ - z1;
        return (float)(MathHelper.func_181159_b((double)z, (double)x) * 57.29577951308232) - 90.0f;
    }

    public static enum TargettingMode {
        NONE((turret, entity) -> false),
        ALL(TargettingMode::isNotWhitelisted),
        MONSTER((turret, entity) -> entity instanceof MonsterEntity),
        GROUND_ONLY((turret, entity) -> entity.func_233570_aj_() && TargettingMode.isNotWhitelisted(turret, entity)),
        AIR_ONLY((turret, entity) -> !entity.func_233570_aj_() && entity.func_226278_cu_() > turret.func_226278_cu_() + 3.0 && TargettingMode.isNotWhitelisted(turret, entity)),
        PLAYER((turret, entity) -> entity.func_200600_R() == EntityType.field_200729_aH && TargettingMode.isNotWhitelisted(turret, entity));

        public static final Set<TargettingMode> GUN_TARGETS;
        public static final Set<TargettingMode> ROCKET_TARGETS;
        private final TurretType.TargetValidator validator;

        private TargettingMode(TurretType.TargetValidator validator) {
            this.validator = validator;
        }

        public boolean isDisabled() {
            return this == NONE;
        }

        public boolean isValidTarget(TurretEntity turret, LivingEntity entity) {
            TurretType.TargetValidator val = TurretType.TargetValidator.and(this.validator, turret.turretType.targetValidator);
            return val.canConsiderAsTarget(turret, entity);
        }

        public static boolean isNotWhitelisted(TurretEntity turret, LivingEntity entity) {
            if (entity.func_200600_R() == EntityType.field_200729_aH) {
                PlayerEntity player = (PlayerEntity)entity;
                UUID uuid = player.func_110124_au();
                return !turret.whitelist.contains(uuid);
            }
            return true;
        }

        static {
            GUN_TARGETS = EnumSet.of(ALL, MONSTER, PLAYER);
            ROCKET_TARGETS = EnumSet.allOf(TargettingMode.class);
        }
    }

    public static final class Turrets {
        public static final TurretType SMG = TurretType.Builder.create().dropAs(new ItemStack((IItemProvider)ModItems.SMG_TURRET)).targetRange(32.0, 8.0).targetSelector(Turrets::getClosest).addTargettingModes(TargettingMode.ROCKET_TARGETS).rotationSpeed(15.0f).attackDelay(2).requiredAmmo(AmmoType.AMMO_45ACP).shootHandler(Turrets::shootSmgBullet).sounds(ModSounds.GUN_VECTOR, 8.0f).shouldStayLockedOnTarget().build();
        public static final TurretType AR = TurretType.Builder.create().dropAs(new ItemStack((IItemProvider)ModItems.AR_TURRET)).targetRange(64.0, 16.0).targetSelector(Turrets::getClosest).addTargettingModes(TargettingMode.ROCKET_TARGETS).rotationSpeed(10.0f).attackDelay(4).requiredAmmo(AmmoType.AMMO_556MM).shootHandler(Turrets::shootArBullet).sounds(ModSounds.GUN_M416, 12.0f).shouldStayLockedOnTarget().build();
        public static final TurretType ROCKET = TurretType.Builder.create().dropAs(new ItemStack((IItemProvider)ModItems.ROCKET_TURRET)).targetRange(96.0, 64.0).targetValidator((turret, target) -> Turrets.getDistanceSqr(target, turret) > 16.0).addTargettingModes(TargettingMode.ROCKET_TARGETS).rotationSpeed(5.0f).attackDelay(80).requiredAmmo(AmmoType.ROCKET).shootHandler(Turrets::shootRocket).sounds(ModSounds.RL_SHOT, 15.0f).build();

        private static AbstractProjectile shootBullet(TurretEntity entity, ItemStack ammo, IAmmoProvider provider, float baseDamage, float dmgMultiplier, float velocity, int delay, float inaccuracy) {
            IAmmoMaterial material = provider.getMaterial();
            float actualDamage = baseDamage + (float)material.defaultLevelRequirement() * dmgMultiplier;
            Bullet bullet = new Bullet((EntityType<? extends Bullet>)((EntityType)ModEntities.BULLET.get()), entity.field_70170_p);
            bullet.func_70107_b(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_());
            bullet.setup(actualDamage, velocity, delay);
            bullet.fire(entity.field_70125_A, entity.field_70177_z, inaccuracy);
            bullet.setProperty(Properties.TRACER, material.getTracerColor() != null ? material.getTracerColor() : 0xCCCC00);
            return bullet;
        }

        private static AbstractProjectile shootSmgBullet(TurretEntity entity, ItemStack ammo, IAmmoProvider provider) {
            return Turrets.shootBullet(entity, ammo, provider, 2.0f, 1.25f, 15.0f, 5, 1.0f);
        }

        private static AbstractProjectile shootArBullet(TurretEntity entity, ItemStack ammo, IAmmoProvider provider) {
            return Turrets.shootBullet(entity, ammo, provider, 4.0f, 2.25f, 20.0f, 8, 0.5f);
        }

        private static AbstractProjectile shootRocket(TurretEntity entity, ItemStack ammo, IAmmoProvider provider) {
            Rocket rocket = new Rocket((EntityType<? extends Rocket>)((EntityType)ModEntities.ROCKET.get()), entity.field_70170_p);
            rocket.func_70107_b(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_());
            rocket.setup(0.0f, 4.0f, 0);
            rocket.fire(entity.field_70125_A, entity.field_70177_z, 0.0f);
            rocket.setProperty(Properties.FUELED, true);
            LivingEntity target = entity.getTarget();
            IAmmoMaterial material = provider.getMaterial();
            if (target != null) {
                rocket.setProperty(Properties.ENTITY_ID, target.func_145782_y());
                rocket.setProperty(Properties.GUIDENANCE, IEntityTrackingGun.GuidenanceProperties.TURRET);
            }
            if (material instanceof IReactiveMaterial) {
                IReactiveMaterial reactiveMaterial = (IReactiveMaterial)((Object)material);
                IReaction reaction = reactiveMaterial.getReaction();
                rocket.setProperty(Properties.REACTION, reaction);
                reaction.writeInitialData(rocket, material, null);
            }
            return rocket;
        }

        private static LivingEntity getClosest(List<LivingEntity> list, TurretEntity turret) {
            return (LivingEntity)list.stream().min((entity1, entity2) -> {
                double d1 = Turrets.getDistanceSqr(entity1, turret);
                double d2 = Turrets.getDistanceSqr(entity2, turret);
                return Double.compare(d1, d2);
            }).orElseThrow(IllegalStateException::new);
        }

        private static double getDistanceSqr(LivingEntity entity, TurretEntity turret) {
            double x = entity.func_226277_ct_() - turret.func_226277_ct_();
            double y = entity.func_226278_cu_() - turret.func_226278_cu_();
            double z = entity.func_226281_cx_() - turret.func_226281_cx_();
            return x * x + y * y + z * z;
        }
    }

    public static final class TurretType {
        private final ItemStack dropStack;
        private final double xzSearchRange;
        private final double ySearchRange;
        private final TargetValidator targetValidator;
        private final TargetSelector targetSelector;
        private final Set<TargettingMode> availableTargettingModes;
        private final float rotationSpeed;
        private final int attackDelay;
        private final ILocatorPredicate<ItemStack> ammoFilter;
        private final ShootHandler shootHandler;
        private final SoundEvent shootSound;
        private final float shootSoundVolume;
        private final boolean adjustTargetAfterShooting;

        private TurretType(Builder builder) {
            this.dropStack = builder.dropStack;
            this.xzSearchRange = builder.xzSearchRange;
            this.ySearchRange = builder.ySearchRange;
            this.targetValidator = builder.targetValidator;
            this.targetSelector = builder.targetSelector;
            this.availableTargettingModes = builder.availableModes;
            this.rotationSpeed = builder.rotationSpeed;
            this.attackDelay = builder.attackDelay;
            this.ammoFilter = builder.ammoFilter;
            this.shootHandler = builder.shootHandler;
            this.shootSound = builder.shootSound;
            this.shootSoundVolume = builder.shootSoundVolume;
            this.adjustTargetAfterShooting = builder.adjustTargetAfterShooting;
        }

        public static final class Builder {
            private ItemStack dropStack = ItemStack.field_190927_a;
            private double xzSearchRange = 16.0;
            private double ySearchRange = 4.0;
            private TargetValidator targetValidator = (turret, target) -> target != null;
            private TargetSelector targetSelector = (list, level) -> (LivingEntity)ModUtils.getRandomListElement(list, level.field_70146_Z);
            private final Set<TargettingMode> availableModes = EnumSet.of(TargettingMode.NONE);
            private float rotationSpeed = 10.0f;
            private int attackDelay = 5;
            private ILocatorPredicate<ItemStack> ammoFilter;
            private ShootHandler shootHandler;
            private SoundEvent shootSound;
            private float shootSoundVolume = 10.0f;
            private boolean adjustTargetAfterShooting = true;

            private Builder() {
            }

            public static Builder create() {
                return new Builder();
            }

            public Builder dropAs(ItemStack stack) {
                this.dropStack = stack;
                return this;
            }

            public Builder targetRange(double xz, double y) {
                this.xzSearchRange = xz;
                this.ySearchRange = y;
                return this;
            }

            public Builder targetValidator(TargetValidator validator) {
                this.targetValidator = validator;
                return this;
            }

            public Builder targetSelector(TargetSelector selector) {
                this.targetSelector = selector;
                return this;
            }

            public Builder addTargettingModes(Set<TargettingMode> modes) {
                this.availableModes.addAll(modes);
                return this;
            }

            public Builder rotationSpeed(float rotationSpeed) {
                this.rotationSpeed = rotationSpeed;
                return this;
            }

            public Builder attackDelay(int delay) {
                this.attackDelay = delay;
                return this;
            }

            public Builder requiredAmmo(AmmoType type) {
                this.ammoFilter = stack -> {
                    if (stack.func_77973_b() instanceof IAmmoProvider) {
                        IAmmoProvider provider = (IAmmoProvider)stack.func_77973_b();
                        return provider.getAmmoType().equals((Object)type);
                    }
                    return false;
                };
                return this;
            }

            public Builder shootHandler(ShootHandler handler) {
                this.shootHandler = handler;
                return this;
            }

            public Builder sounds(SoundEvent shootSound, float volume) {
                this.shootSound = shootSound;
                this.shootSoundVolume = volume;
                return this;
            }

            public Builder shouldStayLockedOnTarget() {
                this.adjustTargetAfterShooting = false;
                return this;
            }

            public TurretType build() {
                return new TurretType(this);
            }
        }

        @FunctionalInterface
        public static interface TargetSelector {
            public LivingEntity getTarget(List<LivingEntity> var1, TurretEntity var2);
        }

        @FunctionalInterface
        public static interface TargetValidator {
            public boolean canConsiderAsTarget(TurretEntity var1, LivingEntity var2);

            public static TargetValidator and(TargetValidator v1, TargetValidator v2) {
                return (turret, entity) -> v1.canConsiderAsTarget(turret, entity) && v2.canConsiderAsTarget(turret, entity);
            }
        }

        @FunctionalInterface
        public static interface ShootHandler {
            public AbstractProjectile createProjectile(TurretEntity var1, ItemStack var2, IAmmoProvider var3);
        }
    }
}

